<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class RoleSeeder extends Seeder
{
    public function run()
    {
        // Limpiar el caché de Spatie para evitar errores
        app()[\Spatie\Permission\PermissionRegistrar::class]->forgetCachedPermissions();

        // 1. Crear o verificar Permisos
        Permission::firstOrCreate(['name' => 'ver expedientes']);
        Permission::firstOrCreate(['name' => 'editar expedientes']);
        Permission::firstOrCreate(['name' => 'eliminar expedientes']);
        Permission::firstOrCreate(['name' => 'gestionar usuarios']);

        // 2. Crear Roles y asignarles permisos
        
        // El Administrador tiene acceso a TODO
        $roleAdmin = Role::firstOrCreate(['name' => 'Admin']);
        $roleAdmin->syncPermissions(Permission::all());

        // El Supervisor puede ver y editar expedientes, pero no puede borrarlos ni crear usuarios
        $roleSupervisor = Role::firstOrCreate(['name' => 'Supervisor']);
        $roleSupervisor->syncPermissions(['ver expedientes', 'editar expedientes']);
    }
}