<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Vehicle extends Model
{
    protected $table = 'vehicles';
    protected $fillable = ['client_id', 'plate', 'vin', 'engine_number', 'type'];

    // Un vehículo pertenece a un cliente
    public function client()
    {
        return $this->belongsTo(Client::class);
    }

    // Un vehículo tiene muchas multas
    public function fines()
    {
        return $this->hasMany(Fine::class);
    }
}