<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Client extends Model
{
    // 1. Apuntamos a tu tabla existente
    protected $table = 'clients'; 

    // 2. Definimos los campos que se pueden llenar
    protected $fillable = ['full_name', 'phone_number', 'email'];

    // 3. Un cliente tiene muchos vehículos
    public function vehicles()
    {
        return $this->hasMany(Vehicle::class);
    }
}