<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Client;

class DashboardController extends Controller
{
    public function index()
    {
        // Traemos todos los clientes, con sus vehículos y las multas de esos vehículos, ordenados del más nuevo al más viejo
        $clientes = Client::with('vehicles.fines')->orderBy('created_at', 'desc')->get();

        return view('home', compact('clientes'));
    }

    public function show($id)
    {
        // Buscamos al cliente por su ID y traemos todos sus vehículos y multas
        $cliente = Client::with('vehicles.fines')->findOrFail($id);
        
        // Lo mandamos a una nueva vista que vamos a crear
        return view('cliente.show', compact('cliente'));
    }
}